package MHA;


import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;

import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtModel;
import virtuoso.jena.driver.VirtuosoQueryExecution;
import virtuoso.jena.driver.VirtuosoQueryExecutionFactory;
import virtuoso.jena.driver.VirtuosoUpdateFactory;
import virtuoso.jena.driver.VirtuosoUpdateRequest;

import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.NTripleWriter;
import com.hp.hpl.jena.reasoner.Derivation;
import com.hp.hpl.jena.reasoner.Reasoner;

import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.vocabulary.RDFS;


public class QueryExample {

	/**
	 * @param args
	 */
	private static class NTripleStamentWriter extends NTripleWriter {
		public static String writeStament(Statement stmt) {
			StringWriter strWriter = new StringWriter();
			PrintWriter pw = new PrintWriter(strWriter);
			writeResource(stmt.getSubject(), pw);
			pw.print(" ");
			writeResource(stmt.getPredicate(), pw);
			pw.print(" ");
			writeNode(stmt.getObject(), pw);
			pw.println(" .");

			return strWriter.toString();
		}
	}
	
	public static void main(String[] args) {
		
		
		// QUERY SPARQL ENDPOINT 
		/*String query = "PREFIX dbpedia-owl: <http://dbpedia.org/ontology/>\n" +
				 	"PREFIX dbpprop: <http://dbpedia.org/property/>\n" +
				 	"PREFIX dbres: <http://dbpedia.org/resource/>\n" +
				 	"\n" +
				 	"SELECT ?x WHERE {\n" +
				 	"?x dbpedia-owl:family dbres:Crambidae.\n" +
				 	"?x dbpedia-owl:binomialAuthority dbres:Johan_Christian_Fabricius.\n" +
				 	"}\n";
		 
	        ResultSet rs = QueryExecutionFactory.sparqlService( "http://dbpedia.org/sparql", query ).execSelect();

	        while ( rs.hasNext() ) {
	            System.out.println( rs.next() );
	        }*/
		// END QUERY SPARQL ENDPOINT
	        
	        
		
		//QUERY for all triples
		
		System.out.println(" QUERY for all triples");
		VirtGraph virtGraph = new VirtGraph ("jdbc:virtuoso://139.91.210.41:1111", "USERNAME", "PASSWORD");
	 	Model virtModel = new VirtModel(virtGraph);
	 	Query sparql = QueryFactory.create(" " +
	 			"SELECT ?s ?p ?o WHERE { GRAPH ?graph { ?s ?p ?o } }"
	 	);
	 	VirtuosoQueryExecution vqe = VirtuosoQueryExecutionFactory.create (sparql, virtGraph);

	 	Model rdfsExample = ModelFactory.createDefaultModel();//NH
		ResultSet results = vqe.execSelect();
		while (results.hasNext()) {
			QuerySolution result = results.nextSolution();
		    //RDFNode graph = result.get("graph");
		    Resource s = result.getResource("s");
		    Property p =  rdfsExample.createProperty(result.getResource("p").toString());
		    RDFNode o = result.get("o");
		    System.out.println(" { " + s + " "+p+" " + o + " . }");
		    
		    //ADD them to the model for the reasoner 
		    rdfsExample.add(s, p, o);
		    
		}
		

	}

       

}
